/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.ucode;

import com.ibm.hsc.auiml.databeans.ucode.APIDownloadError;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyApplyUpdates;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsButtonHandlerTask;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsClientData;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsData;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsExt;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsUtils;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyRunSurveyTask;
import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceList;
import com.ibm.hsc.auiml.databeans.ucode.SurveyFileResult;
import com.ibm.hsc.auiml.databeans.ucode.UcodeSurveyDownload;
import com.ibm.hsc.auiml.databeans.ucode.UcodeSurveyException;
import com.ibm.hsc.auiml.databeans.ucode.XMLFileResult;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.fw.HException;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class IOSurveyResultsAPI {
    private final String TRACE_MASKD = "JUCODECD";
    private final String TRACE_MASKF = "JUCODECF";
    private final String TRACE_MASKT = "JUCODECT";
    private final String XML = ".xml";
    private final String RPM = ".rpm";
    private final String DEFAULT_TARGET_DIRECTORY = "/var/adm/invscout/";
    private final String MICROCODE_TARGET_DIRECTORY = "/var/adm/invscout/microcode/";
    private final String catalogFile = "catalog.mic";
    IOSurveyResultsData resultsData;
    IOSurveyResultsClientData clientData;
    IOSurveyResultsButtonHandlerTask buttonHandler;
    protected SurveyFileResult[] inSurveyFile = null;
    protected ArrayList resourceExceptions;
    boolean currentSystemLevel = true;

    public IOSurveyResultsAPI() throws HException {
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "-> IOSurveyResultsAPI()");
        }
        this.resultsData = new IOSurveyResultsData();
        this.resourceExceptions = new ArrayList();
        this.resultsData.setIOUtils(new IOSurveyResultsUtils());
        this.resultsData.setIOResultsExt(new IOSurveyResultsExt(this.resultsData));
        this.resultsData.setIODownload(new UcodeSurveyDownload(this.resultsData));
        this.resultsData.setTaskletInterface(false);
        try {
            this.resultsData.getIOResultsExt().initProperties();
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            if (2 <= Trace.LEVEL) {
                Trace.trace("JUCODECF", "Exception caught loading properties file: " + ucodeSurveyException);
            }
            HException hException = new HException(ucodeSurveyException.toString());
            throw hException;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "<- IOSurveyResultsAPI()");
        }
    }

    private void setSurveyExceptions(ArrayList arrayList) {
        this.resourceExceptions = arrayList;
    }

    public ArrayList getSurveyExceptions() {
        return this.resourceExceptions;
    }

    public ArrayList getResourceCheckedList() {
        Iterator iterator;
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "-> IOSurveyResultsAPI().getResourceUpdateList");
        }
        if (this.resultsData == null) {
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECF", "resultsData structure was null");
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getResourceUpdateList");
            }
            return null;
        }
        ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>();
        ResourceList resourceList = this.resultsData.getResources();
        if (resourceList == null) {
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECF", "No data in Resource List");
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getResourceUpdateList");
            }
            return null;
        }
        ArrayList arrayList2 = resourceList.getResourceList();
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECF", arrayList2.size() + " returned resources...");
        }
        if ((iterator = arrayList2.iterator()) == null) {
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECF", "No SurveyResults available...");
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getResourceUpdateList");
            }
            return null;
        }
        while (iterator.hasNext()) {
            ResourceItem resourceItem = (ResourceItem)iterator.next();
            if (!resourceItem.getChecked()) continue;
            arrayList.add(resourceItem);
        }
        if (arrayList.size() == 0) {
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECF", "No SurveyResults available...");
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getResourceUpdateList");
            }
            return null;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECF", arrayList.size() + " SurveyResults available...");
            Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getResourceUpdateList");
        }
        return arrayList;
    }

    public ResourceList getResourceList() {
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "-> IOSurveyResultsAPI().getResourceList");
        }
        if (this.resultsData == null) {
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECF", "resultsData structure was null");
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getResourceList");
            }
            return null;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getResourceList");
        }
        return this.resultsData.getResources();
    }

    public ResourceList startSurvey(RepositoryItem repositoryItem, ArrayList arrayList) throws HException {
        ResourceList resourceList;
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "-> IOSurveyResultsAPI().startSurvey");
        }
        IOSurveyResultsUtils iOSurveyResultsUtils = new IOSurveyResultsUtils();
        this.resultsData.setSurveyResults(null);
        this.resultsData.setReposLevel(repositoryItem);
        if (arrayList == null || arrayList.size() == 0) {
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECF", "Input Targets Value is null or size is zero");
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().startSurvey");
            }
            return null;
        }
        this.resultsData.setTargets(arrayList);
        try {
            IOSurveyRunSurveyTask iOSurveyRunSurveyTask = new IOSurveyRunSurveyTask(this.resultsData);
            this.inSurveyFile = iOSurveyRunSurveyTask.runSurvey();
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            this.setSurveyExceptions(this.resultsData.getResourceExceptions());
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECF", "Survey produced error(s) throw Exception for the API.");
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().startSurvey");
            }
            HException hException = new HException(ucodeSurveyException.toString());
            throw hException;
        }
        try {
            repositoryItem = this.resultsData.getReposLevel();
            resourceList = iOSurveyResultsUtils.createResources(this.inSurveyFile, repositoryItem, this.resultsData);
            if (resourceList == null) {
                if (1 <= Trace.LEVEL) {
                    Trace.trace("JUCODECD", "No resources have been found. ");
                    Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().startSurvey");
                }
                return null;
            }
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECD", "Exception thrown creating resources:\n" + ucodeSurveyException);
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().startSurvey");
            }
            HException hException = new HException(ucodeSurveyException.toString());
            throw hException;
        }
        this.resultsData.setResources(resourceList);
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().startSurvey");
        }
        return resourceList;
    }

    public ArrayList downloadFixpack(RepositoryItem repositoryItem, ArrayList arrayList) throws HException {
        ArrayList arrayList2 = this.downloadFixpack(repositoryItem, arrayList, "/var/adm/invscout/");
        return arrayList2;
    }

    public ArrayList downloadFixpack(RepositoryItem repositoryItem, ArrayList arrayList, String string) throws HException {
        Object object;
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        ArrayList<APIDownloadError> arrayList2 = new ArrayList<APIDownloadError>();
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "-> IOSurveyResultsAPI().downloadFixpack");
        }
        try {
            object = arrayList.iterator();
            if (object == null) {
                if (1 <= Trace.LEVEL) {
                    Trace.trace("JUCODECF", "No SurveyResults available...");
                    Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().downloadFixpack");
                }
                HException hException = new HException("No repository items were supplied");
                throw hException;
            }
            while (object.hasNext()) {
                string2 = (String)object.next();
                try {
                    this.downloadFile(repositoryItem, string2, string);
                }
                catch (Exception exception) {
                    APIDownloadError aPIDownloadError = new APIDownloadError(string2, 8, exception.toString());
                    arrayList2.add(aPIDownloadError);
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            HException hException = new HException((Throwable)exception);
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECF", "Error(s) downloading RPMs: " + exception);
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().downloadFixpack");
            }
            throw hException;
        }
        if (bl) {
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECF", "Error(s) downloading RPMs: " + string3);
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().downloadFixpack");
            }
            object = new HException(string3);
            throw object;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().downloadFixpack");
        }
        return arrayList2;
    }

    public void applyIOMicrocode(ArrayList arrayList) throws HException {
        this.applyIOMicrocode(arrayList, "/var/adm/invscout/");
    }

    public void applyIOMicrocode(ArrayList arrayList, String string) throws HException {
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "-> IOSurveyResultsAPI().applyIOMicrocode");
        }
        ArrayList arrayList2 = new ArrayList();
        try {
            IOSurveyApplyUpdates iOSurveyApplyUpdates = new IOSurveyApplyUpdates(this.resultsData);
            arrayList2 = iOSurveyApplyUpdates.applyUpdate(arrayList, string);
        }
        catch (Exception exception) {
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECT", "Exception aplying IO Microcode " + exception);
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().applyIOMicrocode");
            }
            HException hException = new HException((Throwable)exception);
            throw hException;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().applyIOMicrocode");
        }
    }

    public String getXMLFileName(String string, String string2) throws HException {
        String string3 = string2 + string.trim() + ".xml";
        String string4 = "";
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "-> IOSurveyResultsAPI().getXMLFileName(" + string3 + ")");
        }
        try {
            String string5;
            File file = new File(string3);
            if (file.exists() && file.isFile()) {
                XMLFileResult xMLFileResult;
                if (2 <= Trace.LEVEL) {
                    Trace.trace("JUCODECF", string3 + " exists, now read in the first/highest fixpack name to append to fileid.");
                }
                if ((string5 = (xMLFileResult = this.resultsData.getIODownload().readFixpackXMLFile(string3)).getFixpackName()) == "") {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("JUCODECF", "Error: can not find a fixpack in xml file " + string3);
                    }
                    throw new HException(HSCResourceBundleUtil.getMessage("UcodeBundleMessages", "0062", "There were no fixpacks found for this device."));
                }
            } else {
                if (2 <= Trace.LEVEL) {
                    Trace.trace("JUCODECF", "Error: can not find xml file " + string3);
                }
                Object[] objectArray = new Object[]{string3};
                HException hException = new HException(HSCResourceBundleUtil.getMessage("UcodeBundleMessages", "0044", "FILE " + objectArray[0] + " not found", objectArray));
                throw hException;
            }
            int n = string5.indexOf("_");
            string4 = string2 + string.trim() + string5.substring(n) + ".xml";
        }
        catch (Exception exception) {
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECT", "Exception find/reading xmlfile " + string3 + ":" + exception);
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getXMLFileName");
            }
            HException hException = new HException((Throwable)exception);
            throw hException;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getXMLFileName");
        }
        return string4;
    }

    public ArrayList getFixpackNames(RepositoryItem repositoryItem, String[] stringArray, String string) throws HException {
        int n;
        String string2 = "";
        String string3 = "";
        int n2 = stringArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "-> IOSurveyResultsAPI().getFixpackNames: input list length=" + n2);
        }
        try {
            for (n = 0; n < n2; ++n) {
                if (!(stringArray[n] == null | stringArray[n].trim().length() == 0)) continue;
                if (1 <= Trace.LEVEL) {
                    Trace.trace("JUCODECF", "No Input SystemIds...");
                    Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getFixpackNames");
                }
                HException hException = new HException("No input systemids were supplied");
                throw hException;
            }
        }
        catch (Exception exception) {
            HException hException = new HException((Throwable)exception);
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECF", "Error checking input: " + exception);
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getFixpackNames");
            }
            throw hException;
        }
        n = 0;
        for (n = 0; n < n2; ++n) {
            Object object;
            try {
                string3 = stringArray[n].trim() + ".xml";
                this.downloadFile(repositoryItem, string3, string);
                if (2 <= Trace.LEVEL) {
                    Trace.trace("JUCODECF", "Successfully downloaded file " + string3 + " to " + string);
                }
                String string4 = "";
                object = new ArrayList();
                string3 = string + stringArray[n].trim() + ".xml";
                XMLFileResult xMLFileResult = this.resultsData.getIODownload().readFixpackXMLFile(string3);
                do {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("JUCODECF", "fixPackFile size=" + xMLFileResult.size() + " records");
                    }
                    if ((string4 = xMLFileResult.getFixpackName()) == "") continue;
                    if (this.resultsData.getIODownload().httpFileExist(string4 + ".rpm")) {
                        ((ArrayList)object).add(string4);
                        if (1 > Trace.LEVEL) continue;
                        Trace.trace("JUCODECF", "Retrieved fixpack: " + string4 + ".rpm");
                        continue;
                    }
                    if (1 > Trace.LEVEL) continue;
                    Trace.trace("JUCODECF", "Filepack: " + string4 + ".rpm" + " was not found on server");
                } while (string4 != "");
                if (1 <= Trace.LEVEL) {
                    Trace.trace("JUCODECF", "Completed searching xml file: " + string3 + " records returned is " + ((ArrayList)object).size());
                }
                if (((ArrayList)object).size() == 0) {
                    arrayList.add(n, new APIDownloadError(string3, 12, HSCResourceBundleUtil.getMessage("UcodeBundleMessages", "0062", "There were no fixpacks found for this device.")));
                } else {
                    arrayList.add(n, object);
                }
                Trace.trace("JUCODECF", "returnFixPackList size = " + arrayList.size());
                continue;
            }
            catch (Exception exception) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace("JUCODECF", "Exception downloading file " + string3 + ":" + exception + "\nreturning APIDownloadError at index " + n);
                }
                object = new APIDownloadError(string3, 8, exception.toString());
                arrayList.add(n, object);
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().getFixpackNames");
        }
        return arrayList;
    }

    private void downloadFile(RepositoryItem repositoryItem, String string, String string2) throws Exception {
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "-> IOSurveyResultsAPI().downloadFile() " + string + " to directory " + string2);
        }
        try {
            this.resultsData.getIODownload().RPMPackageDownload(string, repositoryItem, string2);
        }
        catch (Exception exception) {
            if (1 <= Trace.LEVEL) {
                Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().downloadFile() ERROR: " + exception);
            }
            throw exception;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("JUCODECT", "<- IOSurveyResultsAPI().downloadFile() Success ");
        }
    }
}

